# * Copyright (C) 2020 Texas Instruments Incorporated - http://www.ti.com/
#  *
#  *
#  *  Redistribution and use in source and binary forms, with or without
#  *  modification, are permitted provided that the following conditions
#  *  are met:
#  *
#  *    Redistributions of source code must retain the above copyright
#  *    notice, this list of conditions and the following disclaimer.
#  *
#  *    Redistributions in binary form must reproduce the above copyright
#  *    notice, this list of conditions and the following disclaimer in the
#  *    documentation and/or other materials provided with the
#  *    distribution.
#  *
#  *    Neither the name of Texas Instruments Incorporated nor the names of
#  *    its contributors may be used to endorse or promote products derived
#  *    from this software without specific prior written permission.
#  *
#  *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
#  *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
#  *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#  *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
#  *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#  *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#  *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#  *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#  *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
#  *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
#  *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#  *
# */


from tkinter import *
import tkinter as tk
from tkinter import ttk
from tkinter.ttk import *
from MT_Commands import serial_ports
import global_vars


def output_settings(self):
    def update_output_display(inst, message):
        inst.Lb3.insert(END, message)
        inst.Lb3.yview(END)
        inst.Lb3.selection_clear(0, 'end')
        return

    # Frame for the Output Display
    self.fr_output_main = tk.Frame(self)
    self.fr_output_main.grid(row=12, column=0, rowspan=6, columnspan=6, padx=5, pady=5, sticky='w')
    if sys.platform.startswith('darwin'):
        self.fr_output_main.config(height=65, width=255, bd=5, highlightbackground="black", highlightthickness=1,
                                   background='white')
    else:
        self.fr_output_main.config(height=65, width=270, bd=5, highlightbackground="black", highlightthickness=1,
                                   background='white')

    # Start Button for the application
    from Start_Callback import start_option
    self.start_button = tk.Button(self.fr_output_main, text='Start Process', state=DISABLED,
                                  command=lambda: start_option(self))
    self.start_button.grid(row=13, column=0, padx=5, pady=5, sticky='w')
    if sys.platform.startswith('darwin'):
        self.start_button.config(font='systemSmallSystemFont', width=19)
    else:
        self.start_button.config(font='Helvetica 10 bold', width=18)

    # Progress Bar
    if sys.platform.startswith('darwin'):
        s = Style()
        s.configure("TProgressbar", thickness=12)
        self.progress = Progressbar(self.fr_output_main, orient=HORIZONTAL, length=300, mode='determinate',
                                    style='TProgressbar')
        self.progress.grid(row=13, column=1, padx=5, pady=5, sticky='w')
    else:
        self.progress = Progressbar(self.fr_output_main, orient=HORIZONTAL, length=290, mode='determinate')
        self.progress.grid(row=13, column=1, padx=5, pady=5)

    # Output Display List Box
    self.Lb3 = tk.Listbox(self.fr_output_main, selectmode=tk.SINGLE, fg='black')
    self.Lb3.grid(row=14, column=0, rowspan=5, columnspan=4, sticky='w', padx=5)
    self.Lb3.config(width=78, height=6, bd=0, highlightthickness=0, activestyle='none', state=NORMAL)
    self.Lb3.bind("<<ListboxSelect>>", lambda e: self.Lb3.selection_clear(0, 'end'))
    self.Lb3.bind('<FocusOut>', self.Lb3.selection_clear(0, END))
    if sys.platform.startswith('darwin'):
        self.Lb3.config(font='systemSmallSystemFont', width=66)

    # Welcome Message
    update_output_display(self, "Welcome to TI Zigbee Network Properties Cloning Tool!")

    # Output Message
    update_output_display(self, 'Please select an Application then Port/s')
    update_output_display(self, 'Press [Start Process] to begin once all selections have been made.')
    return
